<?php
require __DIR__.'/config.php';
role_required('user');
$msg=flash();
$today=date('Y-m-d');
$uid=(int)$_SESSION['user']['id'];
$st=$db->prepare('SELECT id,tanggal,waktu,foto_path FROM absensi WHERE user_id=? AND tanggal=? LIMIT 1');
$st->bind_param('is',$uid,$today);
$st->execute();
$today_absen=$st->get_result()->fetch_assoc();
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Dashboard User</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container">
    <a class="navbar-brand" href="#">Absensi User</a>
    <div class="d-flex ms-auto">
      <span class="navbar-text text-white me-3"><?=esc($_SESSION['user']['username'])?></span>
      <a class="btn btn-light" href="logout.php">Logout</a>
    </div>
  </div>
</nav>
<div class="container py-4">
  <?php if($msg){ ?><div class="alert alert-info"><?=$msg?></div><?php } ?>
  <div class="row justify-content-center">
    <div class="col-md-6">
      <div class="card shadow-sm">
        <div class="card-body text-center">
          <h5 class="mb-3">Tanggal <?=esc(date('d/m/Y'))?></h5>
          <?php if($today_absen){ ?>
            <div class="alert alert-success">Anda sudah absen pukul <?=esc($today_absen['waktu'])?></div>
            <?php if($today_absen['foto_path']&&file_exists(__DIR__.'/foto/'.$today_absen['foto_path'])){ ?>
              <img src="foto/<?=esc($today_absen['foto_path'])?>" class="img-thumbnail" style="width:160px;height:160px;object-fit:cover;">
            <?php } ?>
          <?php } else { ?>
            <a class="btn btn-lg btn-primary" href="absen.php">Absen Sekarang</a>
          <?php } ?>
        </div>
      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
