<?php
require __DIR__.'/config.php';
role_required('admin');
$users_count=(int)$db->query('SELECT COUNT(*) c FROM users')->fetch_assoc()['c'];
$today=date('Y-m-d');
$absen_today=(int)$db->query("SELECT COUNT(*) c FROM absensi WHERE tanggal='$today'")->fetch_assoc()['c'];
$absensi=$db->query('SELECT a.id,u.username,a.tanggal,a.waktu,a.foto_path FROM absensi a JOIN users u ON u.id=a.user_id ORDER BY a.id DESC LIMIT 200');
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Dashboard Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container">
    <a class="navbar-brand" href="#">Absensi Admin</a>
    <div class="d-flex ms-auto">
      <a class="btn btn-outline-light me-2" href="dashboard_admin.php">Dashboard</a>
      <a class="btn btn-outline-light me-2" href="admin/users.php">Kelola User</a>
      <a class="btn btn-light" href="logout.php">Logout</a>
    </div>
  </div>
</nav>
<div class="container py-4">
  <div class="row g-3 mb-4">
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center">
            <div>
              <div class="text-muted">Jumlah User</div>
              <div class="h4"><?=$users_count?></div>
            </div>
            <span class="badge bg-secondary">User</span>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center">
            <div>
              <div class="text-muted">Absensi Hari Ini</div>
              <div class="h4"><?=$absen_today?></div>
            </div>
            <span class="badge bg-success">Hari Ini</span>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center">
            <div>
              <div class="text-muted">Tanggal</div>
              <div class="h4"><?=esc(date('d/m/Y'))?></div>
            </div>
            <span class="badge bg-info">Info</span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="card shadow-sm">
    <div class="card-header">Data Absensi Terbaru</div>
    <div class="table-responsive">
      <table class="table table-striped align-middle mb-0">
        <thead>
          <tr>
            <th>#</th><th>User</th><th>Tanggal</th><th>Waktu</th><th>Foto</th>
          </tr>
        </thead>
        <tbody>
        <?php $no=1; while($r=$absensi->fetch_assoc()){ ?>
          <tr>
            <td><?=$no++?></td>
            <td><?=esc($r['username'])?></td>
            <td><?=esc(date('d/m/Y',strtotime($r['tanggal'])))?></td>
            <td><?=esc($r['waktu'])?></td>
            <td>
              <?php if($r['foto_path']&&file_exists(__DIR__.'/foto/'.$r['foto_path'])){ ?>
                <img src="foto/<?=esc($r['foto_path'])?>" class="img-thumbnail" style="width:80px;height:80px;object-fit:cover;">
              <?php } else { echo '<span class="text-muted">Tidak ada</span>'; } ?>
            </td>
          </tr>
        <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
