<?php
require __DIR__.'/../config.php';
role_required('admin');
$msg=flash();
if($_SERVER['REQUEST_METHOD']==='POST'){
  $action=$_POST['action']??'';
  if($action==='add'){
    $username=trim($_POST['username']??'');
    $password=trim($_POST['password']??'');
    $role=($_POST['role']??'user')==='admin'?'admin':'user';
    if($username!==''&&$password!==''){
      $stmt=$db->prepare('INSERT INTO users(username,password,role,created_at) VALUES(?,?,?,NOW())');
      $stmt->bind_param('sss',$username,$password,$role);
      $stmt->execute();
      flash('User ditambahkan');
    } else { flash('Input tidak valid'); }
    header('Location: users.php');exit;
  } elseif($action==='edit'){
    $id=(int)($_POST['id']??0);
    $username=trim($_POST['username']??'');
    $password=trim($_POST['password']??'');
    $role=($_POST['role']??'user')==='admin'?'admin':'user';
    if($id>0&&$username!==''){
      if($password!==''){
        $stmt=$db->prepare('UPDATE users SET username=?, password=?, role=? WHERE id=?');
        $stmt->bind_param('sssi',$username,$password,$role,$id);
      } else {
        $stmt=$db->prepare('UPDATE users SET username=?, role=? WHERE id=?');
        $stmt->bind_param('ssi',$username,$role,$id);
      }
      $stmt->execute();
      flash('User diupdate');
    } else { flash('Input tidak valid'); }
    header('Location: users.php');exit;
  }
}
if(isset($_GET['delete'])){
  $id=(int)$_GET['delete'];
  if($id>0){
    $stmt=$db->prepare('DELETE FROM users WHERE id=?');
    $stmt->bind_param('i',$id);
    $stmt->execute();
    flash('User dihapus');
  }
  header('Location: users.php');exit;
}
$users=$db->query('SELECT id,username,role,created_at FROM users ORDER BY id DESC');
$edit_id=(int)($_GET['edit']??0);
$edit=null;
if($edit_id>0){
  $st=$db->prepare('SELECT id,username,role FROM users WHERE id=?');
  $st->bind_param('i',$edit_id);
  $st->execute();
  $res=$st->get_result();
  $edit=$res->fetch_assoc();
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Kelola User</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container">
    <a class="navbar-brand" href="../dashboard_admin.php">Absensi Admin</a>
    <div class="d-flex ms-auto">
      <a class="btn btn-outline-light me-2" href="../dashboard_admin.php">Dashboard</a>
      <a class="btn btn-light" href="../logout.php">Logout</a>
    </div>
  </div>
</nav>
<div class="container py-4">
  <?php if($msg){ ?><div class="alert alert-info"><?=$msg?></div><?php } ?>
  <div class="row">
    <div class="col-md-5">
      <div class="card shadow-sm mb-4">
        <div class="card-header"><?= $edit ? 'Edit User' : 'Tambah User' ?></div>
        <div class="card-body">
          <form method="post">
            <input type="hidden" name="action" value="<?= $edit ? 'edit' : 'add' ?>">
            <?php if($edit){ ?><input type="hidden" name="id" value="<?=esc($edit['id'])?>"><?php } ?>
            <div class="mb-3">
              <label class="form-label">Username</label>
              <input type="text" name="username" class="form-control" required value="<?= esc($edit['username']??'') ?>">
            </div>
            <div class="mb-3">
              <label class="form-label">Password <?= $edit ? '(kosongkan jika tidak diubah)' : '' ?></label>
              <input type="text" name="password" class="form-control" <?= $edit ? '' : 'required' ?>>
            </div>
            <div class="mb-3">
              <label class="form-label">Role</label>
              <select name="role" class="form-select">
                <option value="user" <?= isset($edit)&&$edit['role']==='user'?'selected':'' ?>>User</option>
                <option value="admin" <?= isset($edit)&&$edit['role']==='admin'?'selected':'' ?>>Admin</option>
              </select>
            </div>
            <div class="d-flex gap-2">
              <button class="btn btn-primary"><?= $edit ? 'Update' : 'Tambah' ?></button>
              <?php if($edit){ ?><a class="btn btn-secondary" href="users.php">Batal</a><?php } ?>
            </div>
          </form>
        </div>
      </div>
    </div>
    <div class="col-md-7">
      <div class="card shadow-sm">
        <div class="card-header">Daftar User</div>
        <div class="table-responsive">
          <table class="table table-striped align-middle mb-0">
            <thead>
              <tr><th>#</th><th>Username</th><th>Role</th><th>Dibuat</th><th>Aksi</th></tr>
            </thead>
            <tbody>
              <?php $no=1; while($u=$users->fetch_assoc()){ ?>
              <tr>
                <td><?=$no++?></td>
                <td><?=esc($u['username'])?></td>
                <td><span class="badge bg-<?= $u['role']==='admin'?'danger':'secondary' ?>"><?=esc($u['role'])?></span></td>
                <td><?=esc($u['created_at'])?></td>
                <td>
                  <a class="btn btn-sm btn-outline-primary" href="users.php?edit=<?=esc($u['id'])?>">Edit</a>
                  <a class="btn btn-sm btn-outline-danger" href="users.php?delete=<?=esc($u['id'])?>" onclick="return confirm('Hapus user ini?')">Hapus</a>
                </td>
              </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
